<?php
namespace index;
use Zend\ServiceManager\ServiceManager,
	Zend\Mvc\Service\ServiceManagerConfig;
	
/**
 * This makes our life easier when dealing with paths. Everything is relative
 * to the application root now.
 */
chdir(dirname(__DIR__));

// Decline static file requests back to the PHP built-in webserver
if (php_sapi_name() === 'cli-server' && is_file(__DIR__ . parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH))) {
    return false;
}

/**
* added by Mikaia
 **/

// Including external and centralized Lib
require_once __DIR__.'/../common_config/const.inc.php';
require_once __DIR__.'/../config/config.inc.php';
require_once __DIR__.'/../common_config/externalLib.config.php';
$appConfig = require_once __DIR__.'/../common_config/application.config.php';

// Including moduleloader file
require_once 'ModuleLoader.class.php'; 
require_once 'init_autoloader.php';

// Setup service manager
$serviceManager = new ServiceManager(new ServiceManagerConfig($appConfig['service_manager']));
$serviceManager->setService('ApplicationConfig', $appConfig);

$moduleManager = $serviceManager->get('ModuleManager');
$moduleManager->loadModules();
//@todo fix me! custom lazy loading of module
$custModules  = $serviceManager->get('custom.modules.lazyloading');
$custModules->loadCustomModules();

// Run the application!
//appConfig is defined in config.inc.php
\Zend\Mvc\Application::init($appConfig)->run();
