<?php
/**
 * Description of Bootstrap
 *
 * @author: jvanomaro
 */

use Zend\Loader\AutoloaderFactory;
use Zend\Mvc\Service\ServiceManagerConfig;
use Zend\ServiceManager\ServiceManager;
use Zend\Stdlib\ArrayUtils;
use \RuntimeException;

class Bootstrap
{
    const CONSOLE_UTIL_SERVICE = 'core.consoleutil';
    const CONSOLE_PARAMETERS_ARG = 'parameters';

    protected static $serviceManager;
    protected static $config;

    /**
     * Init bootstrap
     */
    public static function init($args)
    {
        // Load the user-defined test configuration file, if it exists; otherwise, load
        $consoleConfig = include 'config/application_console.config.php';

        $zf2ModulePaths = array();

        if (isset($consoleConfig['module_listener_options']['module_paths'])) {
            $modulePaths = $consoleConfig['module_listener_options']['module_paths'];
            foreach ($modulePaths as $modulePath) {
                if (($path = static::findParentPath($modulePath)) ) {
                    $zf2ModulePaths[] = $path;
                }
            }
        }

        $zf2ModulePaths = implode(PATH_SEPARATOR, $zf2ModulePaths) . PATH_SEPARATOR;
        $zf2ModulePaths .= getenv('ZF2_MODULES_TEST_PATHS') ?: (defined('ZF2_MODULES_TEST_PATHS') ? ZF2_MODULES_TEST_PATHS : '');

        static::initAutoloader();

        // use ModuleManager to load this module and it's dependencies
        $baseConfig = array(
            'module_listener_options' => array(
                'module_paths' => explode(PATH_SEPARATOR, $zf2ModulePaths),
            ),
        );

        $config = ArrayUtils::merge($baseConfig, $consoleConfig);

        $serviceManager = new ServiceManager(new ServiceManagerConfig());
        $serviceManager->setService('ApplicationConfig', $config);

        $serviceManager->get('ModuleManager')->loadModules();
        
        $consoleUtilService = $serviceManager->get(self::CONSOLE_UTIL_SERVICE);
        $siteConfigHandler = $serviceManager->get('site.configuration.handler');
        
        //Setting site config
        $strParam = static::getParam($args, self::CONSOLE_PARAMETERS_ARG);
        
        if( empty($strParam) )
        {
            die('argument --parameters missing');
        }

        $strSiteConfig = $consoleUtilService->getStrSiteConfigFromExpression($strParam);
        $siteConfigHandler->setConfig($strSiteConfig);
        
        $serviceManager->setAllowOverride(true);
        $serviceManager->setService('site.configuration.handler', $siteConfigHandler);
        //End setting site config

        static::$serviceManager = $serviceManager;
        static::$config = $config;

        // Setting SERVER
        $site = $consoleUtilService->getValueFromExpression('KEY_SITE', $strParam);

    	$_SERVER['SERVER_NAME'] = $site;
    	define('KEY', sha1($_SERVER['SERVER_NAME']));
        // End setting SERVER

        $application  = $serviceManager->get('Application');
        $application->bootstrap()->run()->send();

        /*//load Configuration
        $configHandler = $serviceManager->get('site.configuration.handler');

        //@todo add key for krypting data for more security
        if($configIdeo = $configHandler->getConfig()){
            //var_dump($configIdeo)   ;die;
            //@Todo lazy loading module
            //foreach($configIdeo->modules as $key=>$module){
            //$index = count($configuration['modules']) -1;
            //array_splice($configuration['modules'], $index,$key -1 ,$module->moduleNom.$module->moduleVersion);
            //$moduleManager->loadModule($module->moduleNom.$module->moduleVersion);
            //}

            //Boostrap and Run application (attache Response and request by default)
            $application  = $serviceManager->get('Application');
            $application->bootstrap()->run()->send();
        }else{
            header('location: Error.php');
        }*/
    }

    private static function getParam($args, $paramName)
    {
    	$res = '';
    	
    	foreach( $args as $option )
    	{
    		if( strpos($option, '--' . $paramName) !== false )
    		{
    			$res = str_replace('--' . $paramName . '=', '', $option);
    		}
    	}

    	return $res;
    }

    /**
     * @return \Zend\ServiceManager\ServiceManager
     */
    public static function getServiceManager()
    {
        return static::$serviceManager;
    }

    /**
     * @return mixed $config
     */
    public static function getConfig()
    {
        return static::$config;
    }

    /**
     * Init autoload
     *
     * @throws RuntimeException
     */
    protected static function initAutoloader()
    {
        $vendorPath = static::findParentPath('vendor');

        if (is_readable($vendorPath . '/autoload.php')) {
            $loader = include $vendorPath . '/autoload.php';
        } else {
            $zf2Path = getenv('ZF2_PATH') ?: (defined('ZF2_PATH') ? ZF2_PATH : (is_dir($vendorPath . '/ZF2/library') ? $vendorPath . '/ZF2/library' : false));

            if (!$zf2Path) {
                throw new RuntimeException('Unable to load ZF2. Run `php composer.phar install` or define a ZF2_PATH environment variable.');
            }

            include $zf2Path . '/Zend/Loader/AutoloaderFactory.php';

        }

        AutoloaderFactory::factory(array(
            'Zend\Loader\StandardAutoloader' => array(
                'autoregister_zf' => true,
                'namespaces' => array(
                    'Doctrine' => $vendorPath . '/Doctrine/',
                    'CoreZendExtension' => $vendorPath . '/CoreZendExtension/',
                    'Gedmo' => $vendorPath . '/Doctrine/Gedmo/Gedmo/',
                    'JMS' => $vendorPath . '/JMS/src/JMS',
                ),
                'prefixes' => array(
                    'Twig' => __DIR__ . '/vendor/CoreTwig/vendor/Twig/lib/Twig',
                    'Mustache' => __DIR__ . '/vendor/CoreMustache_1_0/vendor/Mustache'
                )
            ),
        ));
    }

    /**
     * Find parent path
     *
     * @param string $path
     * @return bool|string
     */
    protected static function findParentPath($path)
    {
        $dir = __DIR__;
        $previousDir = '.';
        while (!is_dir($dir . '/' . $path)) {
            $dir = dirname($dir);
            if ($previousDir === $dir) return false;
            $previousDir = $dir;
        }
        return $dir . '/' . $path;
    }
}
