<?php

/**
 * Description of ModuleLoader
 *
 * @author rmikaia
 */
class ModuleLoader {
    /**
	 * Load all modules in configurations list  
	 * @param mixed $modules
	 * @param string $libsDir
	 */
	public static function loadModules($modules, $libsDir)
	{
        //var_dump($this);
		// zend autoloader
		$loader = new Zend\Loader\StandardAutoloader();
		
		// check if modules list is set  
		if(is_array($modules) && count($modules) > 0)
		{
			// parse modules list
			foreach($modules as $name => $module)
			{
				// check if type and path are setting up  
				if(isset($module['type']) && isset($module['path']))
				{
                    ModuleLoader::registerModulesByNamespace($module, $libsDir, $loader, $name);
                    
				}				
			} 
			$loader->setFallbackAutoloader(true);
			$loader->register();
		}
	}
    
    private static function registerModulesByNamespace($module, $libsDir, $loader, $name) {
        
        switch ($module ['type']) {
            case 'core':
                //var_dump($name . ' => ' . $libsDir['vendor'] . $module['path']);
                $loader->registerNamespace($name, $libsDir['vendor'] . $module['path']);
                break;

            case 'ideo':
                //var_dump($name . ' => ' . $libsDir['module'] . $module['path']);
                $loader->registerNamespace($name, $libsDir['module'] . $module['path']);
                break;

            default:
                break;
        }
    }
}
