<?php

/**
 * This autoloading setup is really more complicated than it needs to be for most
 * applications. The added complexity is simply to reduce the time it takes for
 * new developers to be productive with a fresh skeleton. It allows autoloading
 * to be correctly configured, regardless of the installation method and keeps
 * the use of composer completely optional. This setup should work fine for
 * most users, however, feel free to configure autoloading however you'd like.
 */
// Composer autoloading
if (file_exists('vendor/autoload.php')) {
  $loader = include 'vendor/autoload.php';
}

$zf2Path = false;
$libsDir = __DIR__;

if (getenv('ZF2_PATH')) {           // Support for ZF2_PATH environment variable or git submodule
    $zf2Path = getenv('ZF2_PATH');
} elseif (get_cfg_var('zf2_path')) { // Support for zf2_path directive value
    $zf2Path = get_cfg_var('zf2_path');
} elseif (defined('LIBS_DIR')) { // use defined library dir
    $aLibs = unserialize(LIBS_DIR);
    $zf2Path = $aLibs['vendor'] . DIRECTORY_SEPARATOR . 'ZF2/library';
    $libsDir = $aLibs['vendor'];
} elseif(is_dir('vendor/ZF2/library')) { // use library in local dir
    $zf2Path  = 'vendor/ZF2/library';
    $libsDir = __DIR__ . '/vendor';
}

// Support for ZF2_PATH environment variable or git submodule
if ($zf2Path) {
  if (isset($loader)) {
    $loader->add('Zend', $zf2Path);
  }
  else {
      global $modulesList;
      
      include $zf2Path . '/Zend/Loader/AutoloaderFactory.php';
      //*
      include $libsDir . '/CoreZendExtension/Loader/LazyLoader.php';

      //loading namespace
      \Zend\Loader\AutoloaderFactory::factory(array(
          'CoreZendExtension\Loader\LazyLoader' => array(
              'enable_zf_mods' => include 'common_config/enabled_zend_modules.config.php',
              'prefixes' => array(
                  'Twig' => $libsDir . '/Twig',
                  'Mustache' => $libsDir . '/Mustache',
              )
          )
      ));
      /*/
      //loading namespace
      \Zend\Loader\AutoloaderFactory::factory(array(
          'Zend\Loader\StandardAutoloader' => array(
              'autoregister_zf' => true,
              'prefixes' => array(
                  'Twig' => $libsDir . '/Twig',
                  'Mustache' => $libsDir . '/Mustache',
              )
          )
      ));
      //*/

    // load all modules in config list
    if (isset($aLibs)) {
        ModuleLoader::loadModules($modulesList, $aLibs);
    } else {
        $loader = new Zend\Loader\StandardAutoloader();
        $loader->registerNamespace('Mustache', __DIR__ . '/vendor/CoreMustache_1_0/');
        $loader->registerNamespace('Doctrine', __DIR__ . '/vendor/Doctrine/');
        $loader->registerNamespace('DoctrineModule', __DIR__ . '/vendor/DoctrineModule/src/DoctrineModule/');
        $loader->registerNamespace('DoctrineMongoODMModule', __DIR__ . '/vendor/DoctrineMongoODMModule/src/DoctrineMongoODMModule/');
        $loader->registerNamespace('Gedmo', __DIR__ . '/vendor/Doctrine/Gedmo/Gedmo/');
        $loader->registerNamespace('CoreLibs', __DIR__ . '/vendor/CoreLibs/');
        $loader->registerNamespace('CoreZendExtension', __DIR__ . '/vendor/CoreZendExtension/');
        $loader->registerNamespace('CoreConnectionService', __DIR__ . '/vendor/CoreConnectionService/');
        $loader->registerNamespace('JMS', __DIR__ . '/vendor/JMS/src/JMS');
        $loader->registerNamespace('Metadata', __DIR__ . '/vendor/metadata/src/Metadata');
        $loader->registerNamespace('PhpCollection', __DIR__ . '/vendor/phpCollection/src/PhpCollection');
        $loader->registerNamespace('PhpOption', __DIR__ . '/vendor/phpOption/src/PhpOption');
        $loader->setFallbackAutoloader(true);
        $loader->register();      
    }

        // load all modules in config list
      //ModuleLoader::loadModules($modulesList, $libsDir);
  }
}

if (!class_exists('Zend\Loader\AutoloaderFactory')) {
  throw new RuntimeException('Unable to load ZF2. Run `php composer.phar install` or define a ZF2_PATH environment variable.');
}
