SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";
SET FOREIGN_KEY_CHECKS=0;

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de données: `ideo3-prod6`
--

-- --------------------------------------------------------

--
-- Structure de la table `block`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->block` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `subType` varchar(50) DEFAULT NULL,
  `index` int(4) DEFAULT '0',
  `options` text,
  `content` text,
  `moduleName` varchar(50) DEFAULT NULL,
  `moduleOptions` text,
  `parentColumn` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `column_fk` (`parentColumn`),
  KEY `ref_block` (`ref`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `column`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->column` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) DEFAULT NULL,
  `index` int(4) DEFAULT '0',
  `width` int(4) DEFAULT NULL,
  `template` text,
  `parentSection` int(11) DEFAULT NULL,
  `options` text,
  PRIMARY KEY (`id`),
  KEY `section_fk` (`parentSection`),
  KEY `ref_section` (`ref`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Structure de la table `f01_field`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->f01_field` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `label` varchar(100) DEFAULT NULL,
  `order` int(11) DEFAULT '1',
  `description` text,
  `placeholder` varchar(100) DEFAULT NULL,
  `column` int(4) DEFAULT '1',
  `type` varchar(100) DEFAULT NULL,
  `maxlength` int(8) DEFAULT '0',
  `isidentifier` tinyint(4) DEFAULT '0',
  `hidden` tinyint(4) DEFAULT '0',
  `options` text,
  `ismandatory` tinyint(4) DEFAULT '0',
  `formulaire` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `const_field_formulaire` (`formulaire`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Structure de la table `f01_form`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->f01_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `action` varchar(100) DEFAULT NULL,
  `ncolumn` int(4) DEFAULT '1',
  `target` varchar(100) DEFAULT '',
  `captcha` tinyint(4) DEFAULT '1',
  `textbutton` varchar(100) DEFAULT NULL,
  `function` text,
  `successmessage` text,
  `lang` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Structure de la table `f01_form_value`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->f01_form_value`(
    `id` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
    `sender_name` VARCHAR(100) NOT NULL,
    `sender_email` VARCHAR(100) NOT NULL,
    `date` DATETIME NOT NULL,
    `metadata` TEXT NOT NULL,
    `data` TEXT NOT NULL,
    `attachments` TEXT NOT NULL,
    `body` TEXT NOT NULL,
    `lang` VARCHAR(10) NOT NULL,
    `read` TINYINT(1) NOT NULL,
    `form` INT(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

-- --------------------------------------------------------

--
-- Structure de la table `gallery01_design`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->gallery01_design` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `design_nom` varchar(255),
  `template` text,
  `gallerystyle` text,
  `annimations` text,
  `name` varchar(255) DEFAULT NULL,
  `options` text,
  `removable` tinyint(1) NOT NULL DEFAULT '1',
  `editable` tinyint(1) NOT NULL DEFAULT '1',
  `default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Contenu de la table `gallery01_design`
--

INSERT INTO `<!--PREFIX-->gallery01_design` (`id`, `design_nom`, `template`, `gallerystyle`, `annimations`, `name`, `options`, `removable`, `editable`, `default`) VALUES
(1, '', '', '', '', 'Diaporama', '[{"optionType":"galleryTemplate","template":"diaporama01","showTitle":true,"sliderHeight":50},{"optionType":"galleryStyle","colors":["#f21f1f","#000000"],"theme":"minimal"},{"optionType":"galleryAnimations","fadeDuration":1000,"invertedTransition":false,"pauseDuration":4000,"showLoader":true,"transition":"vertical","autoplay":true}]', 0, 0, 1),
(2, ' ', ' ', ' ', ' ', 'Galerie', '[{"lightbox":true,"optionType":"galleryTemplate","template":"galerie01","sliderHeight":40},{"colors":{"color01":"#999999"},"theme":"minimal","optionType":"galleryStyle"},{"transitions":{"in":false,"out":false},"autoplay":true,"pauseDuration":4000,"optionType":"galleryAnimations"}]', 1, 1, 0);

-- --------------------------------------------------------

--
-- Structure de la table `gallery01_tempales`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->gallery01_tempales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `html` text NOT NULL,
  `styles` text NOT NULL,
  `category` text NOT NULL,
  `icon` text NOT NULL,
  `themes` text NOT NULL,
  `colors` text NOT NULL,
  `animations` tinyint(4) NOT NULL DEFAULT '1',
  `defaults` tinyint(4) NOT NULL DEFAULT '1',
  `config` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Contenu de la table `gallery01_tempales`
--

INSERT INTO `<!--PREFIX-->gallery01_tempales` (`id`, `name`, `html`, `styles`, `category`, `icon`, `themes`, `colors`, `animations`, `defaults`, `config`) VALUES
(1, 'bandeau', '<div class="ideoslider <%=template.name%>" data-style="<%=template.name%>" data-type-model="exemple">	<div class="blockMiniaturesWrapper">		<div class="miniaturesWrapper">			<% fileGroup.files.each(function(file){ %>                        <div class="miniatures" data-fb-group="ideoslider_<%=uid%>" data-fb-src="<%=file.fileUrl%>" data-src="<%=file.fileUrl%>" data-fb-title="<%=file.title%>" data-fb-desc="<%=file.desc%>"><div class="miniImage"></div></div>                        			<% });%>		</div>		<div class="btnPrevMiniature"></div>		<div class="btnNextMiniature"></div>	</div></div>', '.transition(@property, @duration, @function, @delay){-webkit-transition:@arguments;-moz-transition:@arguments;-ms-transition:@arguments;-o-transition:@arguments;transition:@arguments;}.border-radius(@radius){-webkit-border-radius:@radius;-moz-border-radius:@radius;border-radius:@radius;}.box-shadow(@shadow){-webkit-box-shadow:@shadow;-moz-box-shadow:@shadow;box-shadow:@shadow;}.user-select(@select){-webkit-touch-callout:@select;-webkit-user-select:@select;-khtml-user-select:@select;-moz-user-select:@select;-ms-user-select:@select;user-select:@select;}.opacity(@opacity){@opacity-ie:@opacity * 100;-ms-filter:e("progid:DXImageTransform.Microsoft.Alpha(Opacity=@{opacity-ie})");filter:e("alpha(opacity=@{opacity-ie})");opacity:@opacity;}.transform(@transform){-webkit-transform:@transform;-moz-transform:@transform;-ms-transform:@transform;-o-transform:@transform;transform:@transform; }body .ideoslider .preventAnim{.transition( none, 0s, ease, 0s );}#<%=uid%>{@animationTime:<%=animationDuration%>ms;.bandeau{.frameSlider{.transition(all, @animationTime, ease, 0s);}.bigWrapperMini{.transition(all, @animationTime, ease, 0s);}.btnPrev,.btnNext{.transition(all, 0.3s, ease-in-out, 0s);}.frameSlider{z-index: 0;.opacity(0);}.frameSlider.animate-in{z-index: 1;.opacity(1);}.frameSlider.animate-out{z-index: 0;.opacity(0);}}@miniHeight:100px;@miniWidth:100px;@loaderSize:40px;@loaderMiniSize:30px;@marginMini: 6px;@color1:<%=colors[0]%>;@color2:<%=colors[1]%>;@radius : 10px;.rounded-corners(@radius: @radius) {  border-radius: @radius;  -webkit-border-radius: @radius;  -moz-border-radius: @radius;}.bandeau{&.ideoslider{position:relative;margin:15px 0;}.blockMiniaturesWrapper{position: relative;padding:17px 45px; }.miniaturesWrapper{position: relative;height:@miniHeight + @marginMini;overflow:hidden;.rounded-corners;}.bigWrapperMini{height:@miniHeight;}.miniatures{float: left;position:relative;margin:@marginMini;width:@miniWidth;height:@miniHeight;background-color:@color2;cursor:pointer;.rounded-corners;&.active{cursor:default;}&:hover{.opacity(0.8);}}.miniImage {width:100%;height:100%;.rounded-corners;}.btnPrevMiniature{cursor: pointer;position: absolute;text-align: center;top: 45%;width:40px;height:40px;background: @color1;background-image: url(../images/btnPrevMiniature.png);background-position: center center;background-repeat: no-repeat;left: 0;.opacity(1);.rounded-corners(@radius * 2);&:hover{.opacity(1);  background: @color2;background-image: url(../images/btnPrevMiniature.png);background-position: center center;background-repeat: no-repeat;}&:hover.inactive, &.inactive{display: none;}}.btnNextMiniature{cursor: pointer;position: absolute;text-align: center;top: 45%;width: 40px;height:40px;background: @color1;background-image: url(../images/btnNextMiniature.png);background-position: center center;background-repeat: no-repeat;right: 0;.opacity(1);.rounded-corners(@radius * 2);&:hover{.opacity(1);  background: @color2;background-image: url(../images/btnNextMiniature.png);background-position: center center;background-repeat: no-repeat;}&:hover.inactive, &.inactive{display: none;}}.slideLoader, .miniLoader{position: absolute;left: 50%;top: 50%;margin-left:-(@loaderSize / 2);margin-top:-(@loaderSize / 2);}.miniLoader{margin-left:-(@loaderMiniSize / 2);margin-top:-(@loaderMiniSize / 2);}}}', 'thumbs', 'icon-gallery-thumbs-only', '[{"name":"minimal","desc":"minimalDesc","icon":"icon"},{"name":"soft","desc":"softDesc","icon":"icon"},{"name":"classic","desc":"classicDesc","icon":"icon"},{"name":"mixed","desc":"mixedDesc","icon":"icon"}]', '["#26272a","#939395"]', 0, 0, '{"classToUse":{"frameSlider":".frameSlider","grandeImage":".grandeImage","frameWrapper":".frameWrapper","btnPrev":".btnPrev","btnNext":".btnNext","miniatures":".miniatures","miniImage":".miniImage","miniaturesWrapper":".miniaturesWrapper","miniaturesWrapperAnim":".bigWrapperMini","btnPrevMiniature":".btnPrevMiniature","btnNextMiniature":".btnNextMiniature","titleGrdImg":".titleGrdImg","descGrdImg":".descGrdImg"},"general":{"cycle":true,"playAnimOnLoad":false,"reverseAnimPrevNav":true,"animTime":1500,"resizeImg":"contain","imgPosition":"top right","keyboardNav":true,"emptyDesc":true},"miniatures":{"switchMini":"click","nbrLine":1,"nbrCol":"auto","direction":"x","nbrDefil":4,"navigation":"arrow"},"diaporama":{"autoStart":false,"delay":500,"frameTime":500,"pause":"hover","btnPause":".btnPause","direction":1},"frameBox":{"frameBoxOn":"miniatures","general":{"overSizing":false,"title":true,"description":true}},"slideLoader":{"color":"#ffffff","diameter":"40"},"slideLoaderMini":{"color":"#ffffff","diameter":"30"}}'),
(2, 'diaporama', '<div class="ideoslider <%=template.name%>" data-style="<%=template.name%>">  <div class="blockGrande">    <div class="frameWrapper">       <% fileGroup.files.each(function(file){ %>      <div class="frameSlider preventAnim">        <div class="grandeImage" data-fb-group="ideoslider_<%=uid%>" data-fb-src="<%=file.fileUrl%>" data-src="<%=file.fileUrl%>" data-fb-title="<%=file.title%>" data-fb-desc="<%=file.desc%>"> </div>      </div>      <% });%>           <div class="loaderDiaporama"></div>    </div>    <div class="btnPrev"></div>    <div class="btnNext"></div>  </div></div>', '.transition(@property, @duration, @function, @delay){-webkit-transition:@arguments;-moz-transition:@arguments;-ms-transition:@arguments;-o-transition:@arguments;transition:@arguments;}.border-radius(@radius){-webkit-border-radius:@radius;-moz-border-radius:@radius;border-radius:@radius;}.box-shadow(@shadow){-webkit-box-shadow:@shadow;-moz-box-shadow:@shadow;box-shadow:@shadow;}.user-select(@select){-webkit-touch-callout:@select;-webkit-user-select:@select;-khtml-user-select:@select;-moz-user-select:@select;-ms-user-select:@select;user-select:@select;}.opacity(@opacity){@opacity-ie:@opacity * 100;-ms-filter:e("progid:DXImageTransform.Microsoft.Alpha(Opacity=@{opacity-ie})");filter:e("alpha(opacity=@{opacity-ie})");opacity:@opacity;}.transform(@transform){-webkit-transform:@transform;-moz-transform:@transform;-ms-transform:@transform;-o-transform:@transform;transform:@transform; }body .ideoslider .preventAnim{.transition( none, 0s, ease, 0s );}#<%=uid%>{@animationTime:<%=animationDuration%>ms;body .ideoslider .preventAnim{.transition( none, 0s, ease, 0s );}.diaporama{.frameSlider{.transition(all, @animationTime, ease, 0s);}.btnPrev,.btnNext{.transition(all, 0.3s, ease-in-out, 0s);}.frameSlider{z-index: 0;.opacity(0);}.frameSlider.animate-in{z-index: 1;.opacity(1);}.frameSlider.animate-out{z-index: 0;.opacity(0);}.loaderDiaporama{.transition(all, 1s, linear, 0s);width:0;height:3px;position:absolute;bottom:0;left:50%;background:rgba(255, 255, 255, 0.75);z-index:100; }.loaderDiaporama.animate-in{width:100%;left: 0;}}@sliderHeight:280px;@loaderSize:40px;@color1:<%=colors[0]%>;@color2:<%=colors[1]%>;@radius : 10px;.rounded-corners(@radius: @radius) {  border-radius: @radius;  -webkit-border-radius: @radius;  -moz-border-radius: @radius;}.diaporama{&.ideoslider{position:relative;margin:15px 3px 35px 3px;height:@sliderHeight;}.blockGrande{position:relative;height:@sliderHeight - 2;overflow:hidden;background:#FFF;padding:10px;.box-shadow( 0px 1px 3px 0px rgba(0, 0, 0, 0.3) );}.frameWrapper{position:relative;height:@sliderHeight;overflow:hidden;}.grandeImage{position:relative;height:@sliderHeight;overflow:hidden;}.frameSlider{z-index: 0;width: 100%;.opacity(0);position:absolute;height:@sliderHeight;background-color:@color2;overflow:hidden;}.btnPrev{cursor: pointer;position: absolute;z-index:9999;text-align: center;top: 50%;margin-top: -25px;width: 35px;height: 20px;padding: 15px 0;left: 0;background: @color1;background-image: url(../images/btnPrevMiniature.png);background-position: center center;background-repeat: no-repeat;.opacity(0);&:hover{.opacity(1);background: @color2;background-image: url(../images/btnPrevMiniature.png);background-position: center center;background-repeat: no-repeat;}}.btnNext{cursor: pointer;position: absolute;z-index:9999;text-align: center;top: 50%;margin-top: -25px;width: 35px;height: 20px;padding: 15px 0;right: 0;background: @color1;background-image: url(../images/btnNextMiniature.png);background-position: center center;background-repeat: no-repeat;.opacity(0);&:hover{.opacity(1);background: @color2;background-image: url(../images/btnNextMiniature.png);background-position: center center;background-repeat: no-repeat;}}.blockGrande:hover .btnPrev, .blockGrande:hover .btnNext{.opacity(1);}.slideLoader{position: absolute;left: 50%;top: 50%;margin-left:-(@loaderSize / 2);margin-top:-(@loaderSize / 2);}}}', 'slide', 'icon-gallery', '[{"name":"minimal","desc":"minimalDesc","icon":"icon"},{"name":"soft","desc":"softDesc","icon":"icon"},{"name":"classic","desc":"classicDesc","icon":"icon"},{"name":"mixed","desc":"mixedDesc","icon":"icon"}]', '["#26272a","#939395"]', 1, 1, '{"classToUse":{"frameSlider":".frameSlider","grandeImage":".grandeImage","frameWrapper":".frameWrapper","btnPrev":".btnPrev","btnNext":".btnNext","miniatures":".miniatures","miniImage":".miniImage","miniaturesWrapper":".miniaturesWrapper","miniaturesWrapperAnim":".bigWrapperMini","btnPrevMiniature":".btnPrevMiniature","btnNextMiniature":".btnNextMiniature","titleGrdImg":".titleGrdImg","descGrdImg":".descGrdImg"},"general":{"cycle":true,"playAnimOnLoad":true,"reverseAnimPrevNav":true,"animTime":1500,"resizeImg":"contain","imgPosition":"center center","keyboardNav":true,"emptyDesc":true},"miniatures":{"switchMini":"click","nbrLine":1,"nbrCol":4,"direction":"x","nbrDefil":4,"navigation":"arrow"},"diaporama":{"autoStart":true,"delay":500,"frameTime":1700,"pause":"hover","btnPause":".btnPause","direction":1},"frameBox":{"frameBoxOn":"grandeImage","general":{"overSizing":false}},"slideLoader":{"color":"#ffffff","diameter":"40"},"slideLoaderMini":{"color":"#ffffff","diameter":"30"}}'),
(3, 'galerie', '<div class="ideoslider <%=template.name%>" data-style="<%=template.name%>">  <div class="blockGrande">    <div class="frameWrapper">       <% fileGroup.files.each(function(file){ %>      <div class="frameSlider preventAnim">        <div class="grandeImage" data-fb-group="ideoslider_<%=uid%>" data-fb-src="<%=file.fileUrl%>" data-src="<%=file.fileUrl%>" data-fb-title="<%=file.title%>" data-fb-desc="<%=file.desc%>">          <div class="description">            <h2 class="titleGrdImg"><%=file.title%></h2>            <p class="descGrdImg"><%=file.desc%></p>          </div>        </div>      </div>      <% });%>     </div>  </div>  <div class="blockMiniaturesWrapper">    <div class="miniaturesWrapper">       <% fileGroup.files.each(function(file){ %>      <div class="miniatures" data-src="<%=file.fileUrl%>"><div class="miniImage"></div></div>      <% });%>     </div>    <div class="btnPrevMiniature"></div>    <div class="btnNextMiniature"></div>  </div></div>', '.transition(@property, @duration, @function, @delay){-webkit-transition:@arguments;-moz-transition:@arguments;-ms-transition:@arguments;-o-transition:@arguments;transition:@arguments;}.border-radius(@radius){-webkit-border-radius:@radius;-moz-border-radius:@radius;border-radius:@radius;}.box-shadow(@shadow){-webkit-box-shadow:@shadow;-moz-box-shadow:@shadow;box-shadow:@shadow;}.user-select(@select){-webkit-touch-callout:@select;-webkit-user-select:@select;-khtml-user-select:@select;-moz-user-select:@select;-ms-user-select:@select;user-select:@select;}.opacity(@opacity){@opacity-ie:@opacity * 100;-ms-filter:e("progid:DXImageTransform.Microsoft.Alpha(Opacity=@{opacity-ie})");filter:e("alpha(opacity=@{opacity-ie})");opacity:@opacity;}.transform(@transform){-webkit-transform:@transform;-moz-transform:@transform;-ms-transform:@transform;-o-transform:@transform;transform:@transform; }body .ideoslider .preventAnim{.transition( none, 0s, ease, 0s );}#<%=uid%>{@animationTime:<%=animationDuration%>ms;.galerie{.frameSlider{.transition(all, @animationTime, ease, 0s);}.bigWrapperMini{.transition(all, @animationTime, ease, 0s);}.description{.transition(all, 0.3s, ease-in-out, 0s);}.frameSlider{z-index: 0;.opacity(0);}.frameSlider.animate-in{z-index: 1;.opacity(1);}.frameSlider.animate-out{z-index: 0;.opacity(0);}}@grandeHeight:480px;@miniHeight:110px;@loaderSize:40px;@loaderMiniSize:30px;@marginMini: 7px;@color1:<%=colors[0]%>;@color2:<%=colors[1]%>;@radius : 10px;.rounded-corners(@radius: @radius) {  border-radius: @radius;  -webkit-border-radius: @radius;  -moz-border-radius: @radius;}#contenu-gauche .galerie .description h2 {font:normal 18px/18px Arial, Helvetica, sans-serif;text-transform:uppercase;color:#FFF;background:none;margin:5px 0 0 0;padding:5px 10px;border:none;}#contenu-gauche .galerie .description p {font: 12px/14px Arial, Helvetica, sans-serif;color:#FFF;margin:0;padding:0 10px 10px;}.galerie{&.ideoslider{position:relative;margin:15px 3px;}.blockGrande{position:relative;height:@grandeHeight - 22;overflow:hidden;border: 1px solid #EEE;background:#FFF;.box-shadow( 0px 1px 3px 0px rgba(0, 0, 0, 0.3));}.frameWrapper{position:relative;margin:10px;height:@grandeHeight - 42;overflow:hidden;}.grandeImage{position:relative;height:@grandeHeight - 42;overflow:hidden;}.frameSlider{z-index: 0;width: 100%;.opacity(0);position:absolute;height:@grandeHeight - 42;background-color:#EDEDED;overflow:hidden;}.description{width:100%;position:absolute;left:0;bottom:-120px;margin:0;background-color: rgba(0, 0, 0, 0.5);background-color: rgb(0, 0, 0) ;}.grandeImage:hover .description{bottom:0;}.blockMiniaturesWrapper{position: relative;padding: 11px;}.miniaturesWrapper{position: relative;overflow:hidden;}.miniatures{position:relative;margin:5px;width:@miniHeight;height:@miniHeight;background-color:@color1;cursor:pointer;border: 5px solid;border-color:lighten(@color1, 100%);.box-shadow( 0px 0px 3px 0px rgba(0, 0, 0, 0.3) );&.active{cursor:default;border-color:lighten(@color1, 50%);}}.miniImage {width:@miniHeight;height:@miniHeight;}.btnPrevMiniature{cursor: pointer;position: absolute;text-align: center;top: 40%;width:40px;height:40px;background: @color1;background-image: url(../images/btnPrevMiniature.png);background-position: center center;background-repeat: no-repeat;left: 0;.opacity(1);&:hover{.opacity(1);  background: @color2;background-image: url(../images/btnPrevMiniature.png);background-position: center center;background-repeat: no-repeat;}&:hover.inactive, &.inactive{display: none;}}.btnNextMiniature{cursor: pointer;position: absolute;text-align: center;top: 40%;width: 40px;height:40px;background: @color1;background-image: url(../images/btnNextMiniature.png);background-position: center center;background-repeat: no-repeat;right: 0;.opacity(1);&:hover{.opacity(1);  background: @color2;background-image: url(../images/btnNextMiniature.png);background-position: center center;background-repeat: no-repeat; }&:hover.inactive, &.inactive{display: none;}}.slideLoader, .miniLoader{position: absolute;left: 50%;top: 50%;margin-left:-(@loaderSize / 2);margin-top:-(@loaderSize / 2);}.miniLoader{margin-left:-(@loaderMiniSize / 2);margin-top:-(@loaderMiniSize / 2);}}}', 'mixed', 'icon-gallery-thumbs', '[{"name":"minimal","desc":"minimalDesc","icon":"icon"},{"name":"soft","desc":"softDesc","icon":"icon"},{"name":"classic","desc":"classicDesc","icon":"icon"},{"name":"mixed","desc":"mixedDesc","icon":"icon"}]', '["#26272a","#939395"]', 1, 0, '{"classToUse":{"frameSlider":".frameSlider","grandeImage":".grandeImage","frameWrapper":".frameWrapper","btnPrev":".btnPrev","btnNext":".btnNext","miniatures":".miniatures","miniImage":".miniImage","miniaturesWrapper":".miniaturesWrapper","miniaturesWrapperAnim":".bigWrapperMini","btnPrevMiniature":".btnPrevMiniature","btnNextMiniature":".btnNextMiniature","titleGrdImg":".titleGrdImg","descGrdImg":".descGrdImg","loaderDiaporama":".loaderDiaporama"},"general":{"cycle":true,"playAnimOnLoad":true,"reverseAnimPrevNav":true,"animTime":1500,"resizeImg":"contain","imgPosition":"center center","keyboardNav":true,"emptyDesc":true},"miniatures":{"switchMini":"click","nbrLine":1,"nbrCol":"auto","direction":"x","nbrDefil":4,"navigation":"arrow"},"diaporama":{"autoStart":true,"delay":1000,"frameTime":1700,"pause":"hover","btnPause":".btnPause","direction":1},"frameBox":{"frameBoxOn":"grandeImage","general":{"overSizing":false,"title":true,"description":true}},"slideLoader":{"color":"#ffffff","diameter":"40"},"slideLoaderMini":{"color":"#ffffff","diameter":"30"}}');

-- --------------------------------------------------------

--
-- Structure de la table `links`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `target` varchar(10) DEFAULT NULL,
  `href` varchar(255) DEFAULT NULL,
  `lang` varchar(10) DEFAULT NULL,
  `showTitle` tinyint(1) DEFAULT NULL,
  `showDesc` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=24 ;

--
-- Contenu de la table `links`
--  ne mettre aucune enregistrement au début

-- --------------------------------------------------------

--
-- Structure de la table `menu01_menu`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->menu01_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `mobile` tinyint(1) DEFAULT NULL,
  `items` text,
  `lang` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Structure de la table `pages`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) DEFAULT NULL,
  `layout` varchar(50) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `createdAt` datetime DEFAULT NULL,
  `modifiedAt` datetime DEFAULT NULL,
  `actif` tinyint(1) DEFAULT NULL,
  `accueil` tinyint(1) DEFAULT '0',
  `url` varchar(255) DEFAULT NULL,
  `lang` varchar(10) DEFAULT NULL,
  `locked` tinyint(1) DEFAULT NULL,
  `mainZone` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `page_ref` (`ref`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Structure de la table `planacces01_adresseconfigplan`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->planacces01_adresseconfigplan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `labeladresse` int(11) NOT NULL,
  `adresse` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `planacces01_adresses`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->planacces01_adresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `rawaddress` varchar(255) DEFAULT NULL,
  `zip` varchar(100) DEFAULT NULL,
  `ville` varchar(100) DEFAULT NULL,
  `pays` varchar(100) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `website` varchar(100) DEFAULT NULL,
  `latitude` varchar(100) DEFAULT NULL,
  `longitude` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Contenu de la table `planacces01_adresses`
--

INSERT INTO `<!--PREFIX-->planacces01_adresses` (`id`, `name`, `rawaddress`, `zip`, `ville`, `pays`, `phone`, `email`, `website`, `latitude`, `longitude`) VALUES
(2, 'Linkeo', '29', '75008', NULL, 'France', '', '', '', '48.8712307', '2.3093474');

-- --------------------------------------------------------

--
-- Structure de la table `planacces01_labeladresse`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->planacces01_labeladresse` (
  `labelAdresseId` int(11) NOT NULL AUTO_INCREMENT,
  `labelAdresseName` varchar(100) DEFAULT NULL,
  `labelAdresseWebsite` varchar(100) DEFAULT NULL,
  `labelAdresseEmail` varchar(100) DEFAULT NULL,
  `labelAdresseTelephone` varchar(100) DEFAULT NULL,
  `labelAdresseRoute` varchar(100) DEFAULT NULL,
  `labelAdresseFrom` varchar(100) DEFAULT NULL,
  `labelAdresseRouteFrom` varchar(100) DEFAULT NULL,
  `labelAdresseTo` varchar(100) DEFAULT NULL,
  `labelAdresseRouteTo` varchar(100) DEFAULT NULL,
  `labelAdresseWalking` varchar(100) DEFAULT NULL,
  `labelAdresseAvoidHighways` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`labelAdresseId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `resources`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->resources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` text,
  `desc` text,
  `fileUrl` varchar(255) DEFAULT NULL,
  `mimeType` varchar(50) DEFAULT NULL,
  `ext` varchar(10) DEFAULT NULL,
  `thumb` text,
  `name` varchar(50) DEFAULT NULL,
  `createdAt` datetime DEFAULT NULL,
  `modifiedAt` datetime DEFAULT NULL,
  `orginalFile` varchar(255) DEFAULT NULL,
  `useCount` int(4) DEFAULT NULL,
  `parentCollection` int(11) DEFAULT NULL,
  `order` int(11) NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ressourceColl_fk` (`parentCollection`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

-- --------------------------------------------------------

--
-- Structure de la table `resources_collections`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->resources_collections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `zipUrl` varchar(255) DEFAULT NULL,
  `length` varchar(4) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `createdAt` datetime DEFAULT NULL,
  `modifiedAt` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Structure de la table `section`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) DEFAULT NULL,
  `locked` tinyint(1) DEFAULT '0',
  `styles` text,
  `editing` tinyint(1) DEFAULT '0',
  `template` text,
  `parentZone` int(11) DEFAULT NULL,
  `options` text,
  PRIMARY KEY (`id`),
  KEY `zone_fk` (`parentZone`),
  KEY `section_ref` (`ref`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Structure de la table `zone`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->zone` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) DEFAULT NULL,
  `refZoneName` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `template` text,
  `isMain` tinyint(1) DEFAULT NULL,
  `parentPage` int(11) DEFAULT NULL,
  `customized` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `page_fk` (`parentPage`),
  KEY `zone_ref` (`ref`) 
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- Structure de la table `zone_version`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->zone_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zone_id` int(11) NOT NULL,
  `zone_content` mediumtext NOT NULL,
  `version_tag` varchar(150) NOT NULL,
  `content_hash` text NOT NULL,
  `date_creation` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contient les versions des zones' AUTO_INCREMENT=1 ;


--
-- Structure de la table `coreHistory_history`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->coreHistory_history` (
  `history_id` int(11) NOT NULL AUTO_INCREMENT,
  `history_user` varchar(100) NOT NULL COMMENT 'Qui à fait l''action?',
  `history_user_mail` varchar(100) DEFAULT NULL,
  `history_module` varchar(50) NOT NULL COMMENT 'Dans quel module s''est déroulé l''action? Page? Contenu? Menu? Fichier?',
  `history_composant` varchar(255) DEFAULT NULL COMMENT 'Quel composant du module a été touché par l''action?',
  `history_composant_type` varchar(100) DEFAULT NULL COMMENT 'Plus précisément, quel est le type de composant affecté par l''action?',
  `history_action` varchar(100) DEFAULT NULL COMMENT 'Quel type d''action a été faite dans le module, sur un composant, ...? Création? Suppression? Changement?',
  `history_page` varchar(100) DEFAULT NULL COMMENT 'Si une page est touchée à l''action, de quel page s''agit il?',
  `history_date` datetime NOT NULL COMMENT 'Quand a eu lieu l''action?',
  `history_old_value` text COMMENT 'Si une valeur a changée, quel est la valeur d''avant?',
  `history_new_value` text COMMENT 'Si une valeur a changée, quel est la nouvelle valeur?',
  `history_cache` text COMMENT 'Les données déjà traitées seront enregistrées ici. Type NULL == donnée non traité, Type "false"==qu''on a pas besoin de traiter, Type string (json) == donnée déjà traitées',
  PRIMARY KEY (`history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Table contenant la liste des traces utilisateurs dans IDEO 3' AUTO_INCREMENT=1 ;

--
-- Contraintes pour la table `block`
--
ALTER TABLE `<!--PREFIX-->block`
  ADD CONSTRAINT `<!--PREFIX-->column_fk` FOREIGN KEY (`parentColumn`) REFERENCES `<!--PREFIX-->column` (`id`);

--
-- Contraintes pour la table `column`
--
ALTER TABLE `<!--PREFIX-->column`
  ADD CONSTRAINT `<!--PREFIX-->section_fk` FOREIGN KEY (`parentSection`) REFERENCES `<!--PREFIX-->section` (`id`);

--
-- Contraintes pour la table `f01_field`
--
ALTER TABLE `<!--PREFIX-->f01_field`
  ADD CONSTRAINT `<!--PREFIX-->const_field_formulaire` FOREIGN KEY (`formulaire`) REFERENCES `<!--PREFIX-->f01_form` (`id`);

--
-- Contraintes pour la table `f01_form_value`
--
ALTER TABLE `<!--PREFIX-->f01_form_value`
  ADD CONSTRAINT `<!--PREFIX-->const_f01_form_value_form` FOREIGN KEY (`form`) REFERENCES `<!--PREFIX-->f01_form` (`id`);

--
-- Contraintes pour la table `section`
--
ALTER TABLE `<!--PREFIX-->section`
  ADD CONSTRAINT `<!--PREFIX-->zone_fk` FOREIGN KEY (`parentZone`) REFERENCES `<!--PREFIX-->zone` (`id`);

--
-- Contraintes pour la table `zone`
--
ALTER TABLE `<!--PREFIX-->zone`
  ADD CONSTRAINT `<!--PREFIX-->page_fk` FOREIGN KEY (`parentPage`) REFERENCES `<!--PREFIX-->pages` (`id`);

--
-- Contraintes pour la table `zone_version`
--
ALTER TABLE `<!--PREFIX-->zone_version`
  ADD CONSTRAINT `<!--PREFIX-->zone_version_ibfk_1` FOREIGN KEY (`zone_id`) REFERENCES `<!--PREFIX-->zone` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION;

--
-- Structure de la table `settings`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->settings` (
  `variable` varchar(50) NOT NULL,
  `valeur` text,
  PRIMARY KEY (`variable`),
  UNIQUE KEY `variable` (`variable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Structure de la table `resources_collections_resources`
--

CREATE TABLE IF NOT EXISTS `<!--PREFIX-->resources_collections_resources` (
  `resources_id` int(11) NOT NULL,
  `resources_collections_id` int(11) NOT NULL,
  `order` int(11) DEFAULT NULL,
  PRIMARY KEY (`resources_id`,`resources_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Table de jointure entre images et collections';
  
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
