<?php
/**
 * Description of Bootstrap
 *
 * @author: jvanomaro
 */

use Zend\Loader\AutoloaderFactory;
use Zend\Mvc\Service\ServiceManagerConfig;
use Zend\ServiceManager\ServiceManager;
use Zend\Stdlib\ArrayUtils;
use \RuntimeException;

class Bootstrap
{
    protected static $serviceManager;
    protected static $config;
    protected static $bootstrap;
    public static $testPath;
    public static $nameSpace;

    /**
     * Init bootstrap
     */
    public static function init()
    {
        // Load the user-defined test configuration file, if it exists; otherwise, load
        if (is_readable(static::$testPath . '/TestConfig.php')) {
            $testConfig = include static::$testPath . '/TestConfig.php';
        } else {
            $testConfig = include static::$testPath . '/TestConfig.php.dist';
        }

        $zf2ModulePaths = array();

        if (isset($testConfig['module_listener_options']['module_paths'])) {
            $modulePaths = $testConfig['module_listener_options']['module_paths'];
            foreach ($modulePaths as $modulePath) {
                if (($path = static::findParentPath($modulePath)) ) {
                    $zf2ModulePaths[] = $path;
                }
            }
        }

        $zf2ModulePaths = implode(PATH_SEPARATOR, $zf2ModulePaths) . PATH_SEPARATOR;
        $zf2ModulePaths .= getenv('ZF2_MODULES_TEST_PATHS') ?: (defined('ZF2_MODULES_TEST_PATHS') ? ZF2_MODULES_TEST_PATHS : '');

        static::initAutoloader();

        // use ModuleManager to load this module and it's dependencies
        $baseConfig = array(
            'module_listener_options' => array(
                'module_paths' => explode(PATH_SEPARATOR, $zf2ModulePaths),
            ),
        );

        $config = ArrayUtils::merge($baseConfig, $testConfig);

        $serviceManager = new ServiceManager(new ServiceManagerConfig());
        $serviceManager->setService('ApplicationConfig', $config);
        $serviceManager->get('ModuleManager')->loadModules();

        static::$serviceManager = $serviceManager;
        static::$config = $config;
    }

    /**
     * @return \Zend\ServiceManager\ServiceManager
     */
    public static function getServiceManager()
    {
        return static::$serviceManager;
    }

    /**
     * @return mixed $config
     */
    public static function getConfig()
    {
        return static::$config;
    }

    /**
     * Init autoload
     *
     * @throws RuntimeException
     */
    protected static function initAutoloader()
    {
        $vendorPath = static::findParentPath('vendor');

        if (is_readable($vendorPath . '/autoload.php')) {
            $loader = include $vendorPath . '/autoload.php';
        } else {
            $zf2Path = getenv('ZF2_PATH') ?: (defined('ZF2_PATH') ? ZF2_PATH : (is_dir($vendorPath . '/ZF2/library') ? $vendorPath . '/ZF2/library' : false));

            if (!$zf2Path) {
                throw new RuntimeException('Unable to load ZF2. Run `php composer.phar install` or define a ZF2_PATH environment variable.');
            }

            include $zf2Path . '/Zend/Loader/AutoloaderFactory.php';

        }

        AutoloaderFactory::factory(array(
            'Zend\Loader\StandardAutoloader' => array(
                'autoregister_zf' => true,
                'namespaces' => array(
                    static::$nameSpace => static::$testPath . '/' . static::$nameSpace,
                    'Doctrine' => $vendorPath . '/Doctrine/',
                    'CoreZendExtension' => $vendorPath . '/CoreZendExtension/',
                ),
            ),
        ));
        //loading namespace
        $loader = new Zend\Loader\StandardAutoloader();
        $loader->registerNamespace('Doctrine', __DIR__ . '/vendor/Doctrine/');
        $loader->registerNamespace('DoctrineModule', __DIR__ . '/vendor/DoctrineModule/src/DoctrineModule/');
        $loader->registerNamespace('DoctrineMongoODMModule', __DIR__ . '/vendor/DoctrineMongoODMModule/src/DoctrineMongoODMModule/');
        $loader->registerNamespace('Gedmo', __DIR__ . '/vendor/Doctrine/Gedmo/Gedmo/');
        $loader->registerNamespace('CoreLibs', __DIR__ . '/vendor/CoreLibs/');
        $loader->registerNamespace('CoreZendExtension', __DIR__ . '/vendor/CoreZendExtension/');
        $loader->registerNamespace('CoreConnectionService', __DIR__ . '/vendor/CoreConnectionService/');
        $loader->registerNamespace('JMS', __DIR__ . '/vendor/JMS/src/JMS');
        $loader->registerNamespace('Metadata', __DIR__ . '/vendor/metadata/src/Metadata');
        $loader->registerNamespace('PhpCollection', __DIR__ . '/vendor/phpCollection/src/PhpCollection');
        $loader->registerNamespace('PhpOption', __DIR__ . '/vendor/phpOption/src/PhpOption');
        $loader->setFallbackAutoloader(true);
        $loader->register();
    }

    /**
     * Find parent path
     *
     * @param string $path
     * @return bool|string
     */
    protected static function findParentPath($path)
    {
        $dir = static::$testPath;
        $previousDir = '.';
        while (!is_dir($dir . '/' . $path)) {
            $dir = dirname($dir);
            if ($previousDir === $dir) return false;
            $previousDir = $dir;
        }
        return $dir . '/' . $path;
    }
}
