
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT;
SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS;
SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION;
SET NAMES utf8;



CREATE TABLE `<!--PREFIX-->news_category` (
  `id` int(11) NOT NULL  AUTO_INCREMENT,
  `idRessource` int(11) DEFAULT NULL,
   PRIMARY KEY (`id`),
   KEY `idRessource` (`idRessource`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;



CREATE TABLE `<!--PREFIX-->news_categoryLang` (
  `idCategory` int(11) NOT NULL DEFAULT '0',
  `idLang` int(11) NOT NULL DEFAULT '0',
  `title` varchar(512) DEFAULT NULL,
  `description` text,
  `url` varchar(1024) DEFAULT NULL,
  `metaTitle` varchar(512) DEFAULT NULL,
  `metaDescription` text,
  PRIMARY KEY (`idCategory`,`idLang`),
  KEY `idLang` (`idLang`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `<!--PREFIX-->news_config` (
  `variable` varchar(50) NOT NULL,
  `valeur` text,
  PRIMARY KEY (`variable`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


CREATE TABLE `<!--PREFIX-->news_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `articleLang` int(11) NOT NULL,
  `content` text,
  `client` varchar(15) NOT NULL,
  `state` int(11) DEFAULT NULL,
  `dateCreation` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;



CREATE TABLE `<!--PREFIX-->news_lang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;



CREATE TABLE `<!--PREFIX-->news_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;



CREATE TABLE `<!--PREFIX-->news_newsCategory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idCategory` int(11) DEFAULT NULL,
  `idNews` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idCategory` (`idCategory`),
  KEY `idNews` (`idNews`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;



CREATE TABLE `<!--PREFIX-->news_newsLang` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idLang` int(11) DEFAULT NULL,
  `idNews` int(11) DEFAULT NULL,
  `idRessource` int(11) DEFAULT NULL,
  `idPage` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `introduction` text,
  `publicationDate` date DEFAULT NULL,
  `programmingDate` date DEFAULT NULL,
  `url` varchar(1024) DEFAULT NULL,
  `metaTitle` text,
  `metaDescription` text,
  `metaOpengraph` text,
   PRIMARY KEY (`id`),
  KEY `idLang` (`idLang`),
  KEY `idNews` (`idNews`),
  KEY `idRessource` (`idRessource`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


ALTER TABLE `<!--PREFIX-->news_category`
  ADD CONSTRAINT `<!--PREFIX-->news_category_ibfk_1` FOREIGN KEY (`idRessource`) REFERENCES `<!--PREFIX-->resources` (`id`);


ALTER TABLE `<!--PREFIX-->news_categoryLang`
  ADD CONSTRAINT `<!--PREFIX-->news_categoryLang_ibfk_1` FOREIGN KEY (`idCategory`) REFERENCES `<!--PREFIX-->news_category` (`id`),
  ADD CONSTRAINT `<!--PREFIX-->news_categoryLang_ibfk_2` FOREIGN KEY (`idLang`) REFERENCES `<!--PREFIX-->news_lang` (`id`);


ALTER TABLE `<!--PREFIX-->news_newsCategory`
  ADD CONSTRAINT `<!--PREFIX-->news_newsCategory_ibfk_1` FOREIGN KEY (`idCategory`) REFERENCES `<!--PREFIX-->news_category` (`id`),
  ADD CONSTRAINT `<!--PREFIX-->news_newsCategory_ibfk_2` FOREIGN KEY (`idNews`) REFERENCES `<!--PREFIX-->news_news` (`id`);


ALTER TABLE `<!--PREFIX-->news_newsLang`
  ADD CONSTRAINT `<!--PREFIX-->news_newsLang_ibfk_1` FOREIGN KEY (`idLang`) REFERENCES `<!--PREFIX-->news_lang` (`id`),
  ADD CONSTRAINT `<!--PREFIX-->news_newsLang_ibfk_2` FOREIGN KEY (`idNews`) REFERENCES `<!--PREFIX-->news_news` (`id`),
  ADD CONSTRAINT `<!--PREFIX-->news_newsLang_ibfk_3` FOREIGN KEY (`idRessource`) REFERENCES `<!--PREFIX-->resources` (`id`);
COMMIT;

SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT;
SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS;
SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION;